<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}


class formValidator {
	var $UE = array(
			"RO",
			"BE",
			"BG",
			"CZ",
			"DK",
			"DE",
			"EE",
			"IE",
			"GR",
			"ES",
			"FR",
			"HR",
			"IT",
			"CY",
			"LV",
			"LT",
			"LU",
			"HU",
			"MT",
			"LN",
			"AT",
			"PL",
			"SI",
			"SK",
			"FI",
			"SE",
			"GB"	//PENDING REMOVAL :))
		);



	public static function newInstance() {
		return new self();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setModule($module) {
		$this->module = $module;

		return $this;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setFields($fields) {
		$this->fields = $fields;

		return $this;
	}
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setValues($values) {
		$this->values = $values;

		return $this;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getErrors() {
		global $_MODULES;

		$fields = $this->fields;
		
		if (is_array($fields)) {
			foreach ($this->fields as $key => $val) {
				$value = $this->values[$val["name"]];

				//validate length
				if ($val["length"] && !$this->validateLength($val , $value)) {
					$errors[$val["name"]] = $val["msg"];
				} else {

					switch ($val["type"]) {
						case "string":
						case "fill":
							if (!$value) {
								$errors[$val["name"]] = $val["msg"];
							}
						break;

						//numeric
						case "numeric":
							if (!($value && is_numeric($value))) {
								$errors[$val["name"]] = $val["msg"];
							}
						break;

						case "email":
							if (!Validate::Email($value)) {
								$errors[$val["name"]] = $val["msg"];
							} elseif ($this->module && is_object($_MODULES["antispam"])) {
								//mailburners validation
								if (!$_MODULES["antispam"]->ValidateEmail($this->module, $value)) {
									$errors[$val["name"]] = $_MODULES["antispam"]->EmailError();
								}
							}								
						break;

						//fuck knows...
						case "phone":

						break;

						case "vat":
							if (!$this->validateVat($val , $value)) {
								$errors[$val["name"]] = $val["msg"];							
							}
						break;

						case "custom":
							if (!$this->validateCustom($val , $value)) {
								$errors[$val["name"]] = $val["msg"];							
							}
						break;

						case "chars":
							if (!$this->validateChars($val , $value)) {
								$errors[$val["name"]] = $val["msg"];							
							}
						break;							
							
					}					
				}				
			}			
		}		
		return $errors;

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function validateLength($field , $value) {

		switch ($field["type"]) {
			default:
				if ($field["length"]["min"] && (strlen($value) < $field["length"]["min"])) {
					return false;
				}

				if ($field["length"]["max"] && (strlen($value) > $field["length"]["max"])) {
					return false;
				}

			break;

			case "numeric":
				if ($field["length"]["min"] && ($value < $field["length"]["min"])) {
					return false;
				}

				if ($field["length"]["max"] && ($value > $field["length"]["max"])) {
					return false;
				}
			break;
		}
				
		return true;
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function validateVat($field, $value) {

		//if no country cant validate
		if (!$field["vat"]["country"]) {
			return true;
		}
		
		$country = $this->values[$field["vat"]["country"]];

		//no country, cant validate vat without it
		if (!$country) {
			return true;
		}

		//not in UE, cant validate
		if (!in_array(strtoupper($country) , $this->UE)) {
			return true;
		}		

		return $this->validateEuVat($country , $value);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function validateEuVAT($country , $vat) {

		//cleanup $vat
		$vat = preg_replace('/\D/', '', $vat);

		if (!$vat) { 
			return false;
		}
		

		$client = new SoapClient("http://ec.europa.eu/taxation_customs/vies/checkVatService.wsdl");
		$response = $client->checkVat(array(
		  'countryCode' => $country,
		  'vatNumber' => $vat,
		));

		if (!$response->valid) {
			return false;
		} else {
			return array(
				"country"	=> $response->countryCode,
				"vat"		=> $response->vatNumber,
				"valid"		=> true,
				"name"		=> $response->name,
				"address"	=> $response->address
			);
		}

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function validateCustom($field , $value) {
		return Validate::Password(
			$value, 
			$field["length"]["min"], 
			$field["custom"]["digits"], 
			$field["custom"]["upper"], 
			$field["custom"]["lower"],
			$field["custom"]["special"]
		);
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function validateChars($field , $value) {
		$tmp = str_split ($value , 1);

		$res = array_diff(
			$field["chars"]["list"],
			$tmp
		);

		if (count($res)) {
			return false;
		}

		return true;		
	}
	
		
	

	function generateFieldsFromTableFormat($fields) {

		if (is_array($fields)) {
			foreach ($fields as $key => $val) {
				$_fields[$val["field_id"]] = $val;
			}

			$fields = $_fields;
			$_fields = array();

			foreach ($fields as $key => $val) {			

				if ($val["field_data_type"] || $val["field_data_required"]) {
				
					$field = array(
						"name"	=> $val["field_code"],
						"msg"	=> $val["field_data_msg_error"],
					);

					//this applies to checklist, droplists etc
					if ($val["field_data_required"]) {
						$field["type"]	= "fill";
					} else {				
						switch ($val["field_data_type"]) {
							case "string":
								$field["length"]["min"] = $val["field_data_min"];
								$field["length"]["max"] = $val["field_data_max"];
								$field["type"] = "string";
							break;

							case "vat":
								$field["vat"] = array(
									"country"	=> $fields[$val["field_data_vat_countries"]]["field_code"]
								);

							case "email":
							case "numeric":
							case "phone":
								$field["type"] = $val["field_data_type"];
							break;

							case "chars":
								$field["type"] = "chars";
								$field["chars"]	= array(
									"list"	=> explode("," , $val["field_data_chars"])
								);

								$field["length"]["min"] = $val["field_data_min"];
								$field["length"]["max"] = $val["field_data_max"];
							break;

							case "custom":
								$field["type"] = "custom";

								$field["length"]["min"] = $val["field_data_min"];
								$field["length"]["max"] = $val["field_data_max"];

								$field["custom"] = array(
									"digits"	=> $val["field_data_custom_min_digits"],
									"upper"		=> $val["field_data_custom_min_uppercase"],
									"lower"		=> $val["field_data_custom_min_lower"],
									"special"	=> $val["field_data_custom_min_special"],
								);
							break;
						}				

						if ($val["field_data_exists"]) {
							$field["exists"] = array(
								"type"	=> $val["field_data_exists"] == "1" ? "1" : "-1",
								"msg"	=> $val["field_data_msg_exist"]
							);
						}
					}					

					$_fields[] = $field;
				}

			}			
		}

		return $_fields;
		

	}
		
}

